*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Phosmet oxon                                         *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\SAS code Final Models\Diagnostics.SAS";
libname EPA "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\kapp data";

/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/
data phosmetoxon_avg;
     set epa.phosmetoxon_avg;
run;
proc sort data=phosmetoxon_avg;
     by id;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhosmetOxon - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=Phosmetoxon_avg);
ods rtf close;



*==> Human vs. rat;

title "Human vs. rat: final model 2";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=PhosmetOxon_avg  tech=newrap lis=3;
      PARMS ha=0.3914	HB=3.9697
			ra=0.5038	RB=5.4555
			ga=0.01124 	gab=0.08346 	gb=1.1754
			S2E=4.9374;

	 bounds ha>0, HB>0, ra>0, RB>0, ga>0, gb>0, S2E>0;

            rha=ha+ua;
			rra=ra+ua;
            rhb=HB+ub;
			rrb=RB+ub;
            PRED = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-6 + H_I__M + rrb*Rat*1e-6 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-4);
      RANDOM  ua ub ~ normal([0, 0],  [ga, gab, gb]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  predict pred out=Resid_HR;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhosmetOxon human-rat.rtf" startpage=no;
%DiagnosticsHR(chemical=PhosmetOxon, model=2)
ods rtf close;
%Calculate_Ki(chemical=PhosmetOxon, Hadj=1e-6, Radj=1e-6);


*===> Adult vs. Infant;

title "Adult vs. Infant: model 2";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=phosmetoxon_avg(where=(Human=1))  tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=.37	adB=.35
			ia=.23 iB=.076
			gha=1.26 	ghab=1.48 	ghb=2.15
			S2E=0.3607;

			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-5 + H_I__M*adult + rib*1e-5*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-2, ghab*1e-2, ghb*1e-2]) SUBJECT=ID out=RandID_AI; 
	  ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	  predict pred out=Resid_AI;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhosmetOxon Adult-Infant.rtf" startpage=no;
%DiagnosticsAI(chemical=PhosmetOxon, model=2)
ods rtf close;


*===> Male vs. Female;

title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=phosmetoxon_avg(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ma=.3366 mb= 0.3520
			fa=.3961 fB=.3909
			gha=-.5455	ghab=-1.2630	ghb=-.3193
			S2E=1.1366;

            rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
            PRED = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-5 + H_I__M*male + rfb*female*1e-5 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-2);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb]) SUBJECT=ID out=RandID_MF; 
	  ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  predict pred out=Resid_MF;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhosmetOxon Male-Female.rtf" startpage=no;
%DiagnosticsMF(chemical=PhosmetOxon, model=2)
ods rtf close;



*===> Caucasian vs. Other Races;


title "Caucasian vs. Other Races: model 3";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=phosmetoxon_avg(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
	PARMS ca=.397	cB=.404
			ora=.3285 orB=.287
			gca=.833 	gcab=.842 	gcb=.089
			gora=.892 	gorab=.605 	gorb=.132
			S2E=.4436;
          	rca=ca+uca;
            rcb=cB+ucb;
			rora=ora+uora;
			rorb=orB+uorb;
            PRED = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-5 + H_I__M*caucasian + rorb*otherrace*1e-5 + H_I__M*otherrace);

      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uca ucb uora uorb ~ normal([0, 0, 0, 0],   [gca*1e-2, 
														gcab*1e-2, gcb*1e-1, 
														0,    0,     gora*1e-2, 
														0,    0,     gorab*1e-2,   gorb*1e-1]) SUBJECT=ID out=RandID_CO; 

	  ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasian ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  predict pred out=Resid_CO;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhosmetOxon Caucasian-Other Races.rtf" startpage=no;
%DiagnosticsCO(chemical=PhosmetOxon, model=3)
ods rtf close;
